/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.aspect;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.PropertyFilter;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.lang.reflect.Method;
import java.util.Date;
import javax.annotation.Resource;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.SecurityUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.jeecg.common.api.dto.LogDTO;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.constant.enums.ModuleType;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.IPUtils;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.base.service.BaseCommonService;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.stereotype.Component;
import org.springframework.validation.BindingResult;
import org.springframework.web.multipart.MultipartFile;

@Aspect
@Component
public class AutoLogAspect {
    @Resource
    private BaseCommonService baseCommonService;

    @Pointcut(value="@annotation(org.jeecg.common.aspect.annotation.AutoLog)")
    public void logPointCut() {
    }

    @Around(value="logPointCut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        long beginTime = System.currentTimeMillis();
        Object result = point.proceed();
        long time = System.currentTimeMillis() - beginTime;
        this.saveSysLog(point, time, result);
        return result;
    }

    private void saveSysLog(ProceedingJoinPoint joinPoint, long time, Object obj) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        LogDTO dto = new LogDTO();
        AutoLog syslog = method.getAnnotation(AutoLog.class);
        if (syslog != null) {
            String content = syslog.value();
            if (syslog.module() == ModuleType.ONLINE) {
                content = this.getOnlineLogContent(obj, content);
            }
            dto.setLogType(syslog.logType());
            dto.setLogContent(content);
        }
        String className = joinPoint.getTarget().getClass().getName();
        String methodName = signature.getName();
        dto.setMethod(className + "." + methodName + "()");
        if (2 == dto.getLogType()) {
            dto.setOperateType(this.getOperateType(methodName, syslog.operateType()));
        }
        HttpServletRequest request = SpringContextUtils.getHttpServletRequest();
        dto.setRequestParam(this.getReqestParams(request, (JoinPoint)joinPoint));
        dto.setIp(IPUtils.getIpAddr(request));
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        if (sysUser != null) {
            dto.setUserid(sysUser.getUsername());
            dto.setUsername(sysUser.getRealname());
        }
        dto.setCostTime(time);
        dto.setCreateTime(new Date());
        this.baseCommonService.addLog(dto);
    }

    private int getOperateType(String methodName, int operateType) {
        if (operateType > 0) {
            return operateType;
        }
        if (methodName.startsWith("list")) {
            return 1;
        }
        if (methodName.startsWith("add")) {
            return 2;
        }
        if (methodName.startsWith("edit")) {
            return 3;
        }
        if (methodName.startsWith("delete")) {
            return 4;
        }
        if (methodName.startsWith("import")) {
            return 5;
        }
        if (methodName.startsWith("export")) {
            return 6;
        }
        return 1;
    }

    private String getReqestParams(HttpServletRequest request, JoinPoint joinPoint) {
        String httpMethod = request.getMethod();
        String params = "";
        if ("POST".equals(httpMethod) || "PUT".equals(httpMethod) || "PATCH".equals(httpMethod)) {
            Object[] paramsArray = joinPoint.getArgs();
            Object[] arguments = new Object[paramsArray.length];
            for (int i = 0; i < paramsArray.length; ++i) {
                if (paramsArray[i] instanceof BindingResult || paramsArray[i] instanceof ServletRequest || paramsArray[i] instanceof ServletResponse || paramsArray[i] instanceof MultipartFile) continue;
                arguments[i] = paramsArray[i];
            }
            PropertyFilter profilter = new PropertyFilter(){

                public boolean apply(Object o, String name, Object value) {
                    return value == null || value.toString().length() <= 500;
                }
            };
            params = JSONObject.toJSONString((Object)arguments, (SerializeFilter)profilter, (SerializerFeature[])new SerializerFeature[0]);
        } else {
            MethodSignature signature = (MethodSignature)joinPoint.getSignature();
            Method method = signature.getMethod();
            Object[] args = joinPoint.getArgs();
            LocalVariableTableParameterNameDiscoverer u = new LocalVariableTableParameterNameDiscoverer();
            String[] paramNames = u.getParameterNames(method);
            if (args != null && paramNames != null) {
                for (int i = 0; i < args.length; ++i) {
                    params = params + "  " + paramNames[i] + ": " + args[i];
                }
            }
        }
        return params;
    }

    private String getOnlineLogContent(Object obj, String content) {
        if (Result.class.isInstance(obj)) {
            Result res = (Result)obj;
            String msg = res.getMessage();
            String tableName = res.getOnlTable();
            if (oConvertUtils.isNotEmpty(tableName)) {
                content = content + ",\u8868\u540d:" + tableName;
            }
            content = res.isSuccess() ? content + "," + (oConvertUtils.isEmpty(msg) ? "\u64cd\u4f5c\u6210\u529f" : msg) : content + "," + (oConvertUtils.isEmpty(msg) ? "\u64cd\u4f5c\u5931\u8d25" : msg);
        }
        return content;
    }
}

