/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.util;

import cn.hutool.crypto.SecureUtil;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.jeecg.common.exception.JeecgBootException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlInjectionUtil {
    private static final Logger log = LoggerFactory.getLogger(SqlInjectionUtil.class);
    private static final String TABLE_DICT_SIGN_SALT = "20200501";
    private static final String xssStr = "and |exec |insert |select |delete |update |drop |count |chr |mid |master |truncate |char |declare |;|or |+|user()";

    public static void checkDictTableSign(String dictCode, String sign, HttpServletRequest request) {
        String accessToken = request.getHeader("X-Access-Token");
        String signStr = dictCode + TABLE_DICT_SIGN_SALT + accessToken;
        String javaSign = SecureUtil.md5((String)signStr);
        if (!javaSign.equals(sign)) {
            log.error("\u8868\u5b57\u5178\uff0cSQL\u6ce8\u5165\u6f0f\u6d1e\u7b7e\u540d\u6821\u9a8c\u5931\u8d25 \uff1a" + sign + "!=" + javaSign + ",dictCode=" + dictCode);
            throw new JeecgBootException("\u65e0\u6743\u9650\u8bbf\u95ee\uff01");
        }
        log.info(" \u8868\u5b57\u5178\uff0cSQL\u6ce8\u5165\u6f0f\u6d1e\u7b7e\u540d\u6821\u9a8c\u6210\u529f\uff01sign=" + sign + ",dictCode=" + dictCode);
    }

    public static void filterContent(String value) {
        if (value == null || "".equals(value)) {
            return;
        }
        value = value.toLowerCase();
        value = value.replaceAll("/\\*.*\\*/", "");
        String[] xssArr = xssStr.split("\\|");
        for (int i = 0; i < xssArr.length; ++i) {
            if (value.indexOf(xssArr[i]) <= -1) continue;
            log.error("\u8bf7\u6ce8\u610f\uff0c\u5b58\u5728SQL\u6ce8\u5165\u5173\u952e\u8bcd---> {}", (Object)xssArr[i]);
            log.error("\u8bf7\u6ce8\u610f\uff0c\u503c\u53ef\u80fd\u5b58\u5728SQL\u6ce8\u5165\u98ce\u9669!---> {}", (Object)value);
            throw new RuntimeException("\u8bf7\u6ce8\u610f\uff0c\u503c\u53ef\u80fd\u5b58\u5728SQL\u6ce8\u5165\u98ce\u9669!--->" + value);
        }
        if (Pattern.matches("show\\s+tables", value)) {
            throw new RuntimeException("\u8bf7\u6ce8\u610f\uff0c\u503c\u53ef\u80fd\u5b58\u5728SQL\u6ce8\u5165\u98ce\u9669!--->" + value);
        }
    }

    public static void filterContent(String[] values) {
        String[] xssArr = xssStr.split("\\|");
        for (String value : values) {
            if (value == null || "".equals(value)) {
                return;
            }
            value = value.toLowerCase();
            value = value.replaceAll("/\\*.*\\*/", "");
            for (int i = 0; i < xssArr.length; ++i) {
                if (value.indexOf(xssArr[i]) <= -1) continue;
                log.error("\u8bf7\u6ce8\u610f\uff0c\u5b58\u5728SQL\u6ce8\u5165\u5173\u952e\u8bcd---> {}", (Object)xssArr[i]);
                log.error("\u8bf7\u6ce8\u610f\uff0c\u503c\u53ef\u80fd\u5b58\u5728SQL\u6ce8\u5165\u98ce\u9669!---> {}", (Object)value);
                throw new RuntimeException("\u8bf7\u6ce8\u610f\uff0c\u503c\u53ef\u80fd\u5b58\u5728SQL\u6ce8\u5165\u98ce\u9669!--->" + value);
            }
            if (!Pattern.matches("show\\s+tables", value)) continue;
            throw new RuntimeException("\u8bf7\u6ce8\u610f\uff0c\u503c\u53ef\u80fd\u5b58\u5728SQL\u6ce8\u5165\u98ce\u9669!--->" + value);
        }
    }

    @Deprecated
    public static void specialFilterContent(String value) {
        String specialXssStr = " exec | insert | select | delete | update | drop | count | chr | mid | master | truncate | char | declare |;|+|";
        String[] xssArr = specialXssStr.split("\\|");
        if (value == null || "".equals(value)) {
            return;
        }
        value = value.toLowerCase();
        value = value.replaceAll("/\\*.*\\*/", "");
        for (int i = 0; i < xssArr.length; ++i) {
            if (value.indexOf(xssArr[i]) <= -1 && !value.startsWith(xssArr[i].trim())) continue;
            log.error("\u8bf7\u6ce8\u610f\uff0c\u5b58\u5728SQL\u6ce8\u5165\u5173\u952e\u8bcd---> {}", (Object)xssArr[i]);
            log.error("\u8bf7\u6ce8\u610f\uff0c\u503c\u53ef\u80fd\u5b58\u5728SQL\u6ce8\u5165\u98ce\u9669!---> {}", (Object)value);
            throw new RuntimeException("\u8bf7\u6ce8\u610f\uff0c\u503c\u53ef\u80fd\u5b58\u5728SQL\u6ce8\u5165\u98ce\u9669!--->" + value);
        }
        if (Pattern.matches("show\\s+tables", value)) {
            throw new RuntimeException("\u8bf7\u6ce8\u610f\uff0c\u503c\u53ef\u80fd\u5b58\u5728SQL\u6ce8\u5165\u98ce\u9669!--->" + value);
        }
    }

    @Deprecated
    public static void specialFilterContentForOnlineReport(String value) {
        String specialXssStr = " exec | insert | delete | update | drop | chr | mid | master | truncate | char | declare |";
        String[] xssArr = specialXssStr.split("\\|");
        if (value == null || "".equals(value)) {
            return;
        }
        value = value.toLowerCase();
        value = value.replaceAll("/\\*.*\\*/", "");
        for (int i = 0; i < xssArr.length; ++i) {
            if (value.indexOf(xssArr[i]) <= -1 && !value.startsWith(xssArr[i].trim())) continue;
            log.error("\u8bf7\u6ce8\u610f\uff0c\u5b58\u5728SQL\u6ce8\u5165\u5173\u952e\u8bcd---> {}", (Object)xssArr[i]);
            log.error("\u8bf7\u6ce8\u610f\uff0c\u503c\u53ef\u80fd\u5b58\u5728SQL\u6ce8\u5165\u98ce\u9669!---> {}", (Object)value);
            throw new RuntimeException("\u8bf7\u6ce8\u610f\uff0c\u503c\u53ef\u80fd\u5b58\u5728SQL\u6ce8\u5165\u98ce\u9669!--->" + value);
        }
        if (Pattern.matches("show\\s+tables", value)) {
            throw new RuntimeException("\u8bf7\u6ce8\u610f\uff0c\u503c\u53ef\u80fd\u5b58\u5728SQL\u6ce8\u5165\u98ce\u9669!--->" + value);
        }
    }
}

