/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.util.dynamic.db;

import com.alibaba.druid.pool.DruidDataSource;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang3.ArrayUtils;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.system.vo.DynamicDataSourceModel;
import org.jeecg.common.util.ReflectHelper;
import org.jeecg.common.util.dynamic.db.DataSourceCachePool;
import org.jeecg.common.util.dynamic.db.FreemarkerParseFactory;
import org.jeecg.common.util.oConvertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

public class DynamicDBUtil {
    private static final Logger log = LoggerFactory.getLogger(DynamicDBUtil.class);

    private static DruidDataSource getJdbcDataSource(DynamicDataSourceModel dbSource) {
        DruidDataSource dataSource = new DruidDataSource();
        String driverClassName = dbSource.getDbDriver();
        String url = dbSource.getDbUrl();
        String dbUser = dbSource.getDbUsername();
        String dbPassword = dbSource.getDbPassword();
        dataSource.setDriverClassName(driverClassName);
        dataSource.setUrl(url);
        dataSource.setTestWhileIdle(true);
        dataSource.setTestOnBorrow(false);
        dataSource.setTestOnReturn(false);
        dataSource.setBreakAfterAcquireFailure(true);
        dataSource.setConnectionErrorRetryAttempts(0);
        dataSource.setUsername(dbUser);
        dataSource.setMaxWait(30000L);
        dataSource.setPassword(dbPassword);
        log.info("******************************************");
        log.info("*                                        *");
        log.info("*====\u3010" + dbSource.getCode() + "\u3011=====Druid\u8fde\u63a5\u6c60\u5df2\u542f\u7528 ====*");
        log.info("*                                        *");
        log.info("******************************************");
        return dataSource;
    }

    public static DruidDataSource getDbSourceByDbKey(String dbKey) {
        DynamicDataSourceModel dbSource = DataSourceCachePool.getCacheDynamicDataSourceModel(dbKey);
        DruidDataSource cacheDbSource = DataSourceCachePool.getCacheBasicDataSource(dbKey);
        if (cacheDbSource != null && !cacheDbSource.isClosed()) {
            log.debug("--------getDbSourceBydbKey------------------\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6DB\u8fde\u63a5-------------------");
            return cacheDbSource;
        }
        DruidDataSource dataSource = DynamicDBUtil.getJdbcDataSource(dbSource);
        if (dataSource == null || !dataSource.isEnable()) {
            throw new JeecgBootException("\u52a8\u6001\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25\uff0cdbKey\uff1a" + dbKey);
        }
        DataSourceCachePool.putCacheBasicDataSource(dbKey, dataSource);
        log.info("--------getDbSourceBydbKey------------------\u521b\u5efaDB\u6570\u636e\u5e93\u8fde\u63a5-------------------");
        return dataSource;
    }

    public static void closeDbKey(String dbKey) {
        DruidDataSource dataSource = DynamicDBUtil.getDbSourceByDbKey(dbKey);
        try {
            if (dataSource != null && !dataSource.isClosed()) {
                dataSource.getConnection().commit();
                dataSource.getConnection().close();
                dataSource.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private static JdbcTemplate getJdbcTemplate(String dbKey) {
        DruidDataSource dataSource = DynamicDBUtil.getDbSourceByDbKey(dbKey);
        return new JdbcTemplate((DataSource)dataSource);
    }

    private static NamedParameterJdbcTemplate getNamedParameterJdbcTemplate(String dbKey) {
        DruidDataSource dataSource = DynamicDBUtil.getDbSourceByDbKey(dbKey);
        return new NamedParameterJdbcTemplate((DataSource)dataSource);
    }

    public static int update(String dbKey, String sql, Object ... param) {
        JdbcTemplate jdbcTemplate = DynamicDBUtil.getJdbcTemplate(dbKey);
        int effectCount = ArrayUtils.isEmpty((Object[])param) ? jdbcTemplate.update(sql) : jdbcTemplate.update(sql, param);
        return effectCount;
    }

    public static int updateByHash(String dbKey, String sql, HashMap<String, Object> data) {
        JdbcTemplate jdbcTemplate = DynamicDBUtil.getJdbcTemplate(dbKey);
        sql = FreemarkerParseFactory.parseTemplateContent(sql, data);
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(jdbcTemplate.getDataSource());
        int effectCount = namedParameterJdbcTemplate.update(sql, data);
        return effectCount;
    }

    public static Object findOne(String dbKey, String sql, Object ... param) {
        List<Map<String, Object>> list = DynamicDBUtil.findList(dbKey, sql, param);
        if (oConvertUtils.listIsEmpty(list)) {
            log.error("Except one, but not find actually");
            return null;
        }
        if (list.size() > 1) {
            log.error("Except one, but more than one actually");
        }
        return list.get(0);
    }

    public static Object findOneByHash(String dbKey, String sql, HashMap<String, Object> data) {
        List<Map<String, Object>> list = DynamicDBUtil.findListByHash(dbKey, sql, data);
        if (oConvertUtils.listIsEmpty(list)) {
            log.error("Except one, but not find actually");
        }
        if (list.size() > 1) {
            log.error("Except one, but more than one actually");
        }
        return list.get(0);
    }

    public static <T> Object findOne(String dbKey, String sql, Class<T> clazz, Object ... param) {
        Map map = (Map)DynamicDBUtil.findOne(dbKey, sql, param);
        return ReflectHelper.setAll(clazz, (Map<String, Object>)map);
    }

    public static <T> Object findOneByHash(String dbKey, String sql, Class<T> clazz, HashMap<String, Object> data) {
        Map map = (Map)DynamicDBUtil.findOneByHash(dbKey, sql, data);
        return ReflectHelper.setAll(clazz, (Map<String, Object>)map);
    }

    public static List<Map<String, Object>> findList(String dbKey, String sql, Object ... param) {
        JdbcTemplate jdbcTemplate = DynamicDBUtil.getJdbcTemplate(dbKey);
        List list = ArrayUtils.isEmpty((Object[])param) ? jdbcTemplate.queryForList(sql) : jdbcTemplate.queryForList(sql, param);
        return list;
    }

    public static Map<String, Object> queryCount(String dbKey, String sql, Map<String, Object> param) {
        NamedParameterJdbcTemplate npJdbcTemplate = DynamicDBUtil.getNamedParameterJdbcTemplate(dbKey);
        return npJdbcTemplate.queryForMap(sql, param);
    }

    public static List<Map<String, Object>> findListByNamedParam(String dbKey, String sql, Map<String, Object> param) {
        NamedParameterJdbcTemplate npJdbcTemplate = DynamicDBUtil.getNamedParameterJdbcTemplate(dbKey);
        List list = npJdbcTemplate.queryForList(sql, param);
        return list;
    }

    public static List<Map<String, Object>> findListByHash(String dbKey, String sql, HashMap<String, Object> data) {
        JdbcTemplate jdbcTemplate = DynamicDBUtil.getJdbcTemplate(dbKey);
        sql = FreemarkerParseFactory.parseTemplateContent(sql, data);
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(jdbcTemplate.getDataSource());
        List list = namedParameterJdbcTemplate.queryForList(sql, data);
        return list;
    }

    public static <T> List<T> findList(String dbKey, String sql, Class<T> clazz, Object ... param) {
        JdbcTemplate jdbcTemplate = DynamicDBUtil.getJdbcTemplate(dbKey);
        List list = ArrayUtils.isEmpty((Object[])param) ? jdbcTemplate.queryForList(sql, clazz) : jdbcTemplate.queryForList(sql, clazz, param);
        return list;
    }

    public static <T> List<T> findListByHash(String dbKey, String sql, Class<T> clazz, HashMap<String, Object> data) {
        JdbcTemplate jdbcTemplate = DynamicDBUtil.getJdbcTemplate(dbKey);
        sql = FreemarkerParseFactory.parseTemplateContent(sql, data);
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(jdbcTemplate.getDataSource());
        List list = namedParameterJdbcTemplate.queryForList(sql, data, clazz);
        return list;
    }

    public static <T> List<T> findListEntities(String dbKey, String sql, Class<T> clazz, Object ... param) {
        List<Map<String, Object>> queryList = DynamicDBUtil.findList(dbKey, sql, param);
        return ReflectHelper.transList2Entrys(queryList, clazz);
    }

    public static <T> List<T> findListEntitiesByHash(String dbKey, String sql, Class<T> clazz, HashMap<String, Object> data) {
        List<Map<String, Object>> queryList = DynamicDBUtil.findListByHash(dbKey, sql, data);
        return ReflectHelper.transList2Entrys(queryList, clazz);
    }
}

