/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.util;

import com.alibaba.fastjson.JSONObject;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsRequest;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import org.jeecg.common.util.DySmsEnum;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.config.StaticConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DySmsHelper {
    private static final Logger logger = LoggerFactory.getLogger(DySmsHelper.class);
    static final String product = "Dysmsapi";
    static final String domain = "dysmsapi.aliyuncs.com";
    static String accessKeyId;
    static String accessKeySecret;

    public static void setAccessKeyId(String accessKeyId) {
        DySmsHelper.accessKeyId = accessKeyId;
    }

    public static void setAccessKeySecret(String accessKeySecret) {
        DySmsHelper.accessKeySecret = accessKeySecret;
    }

    public static String getAccessKeyId() {
        return accessKeyId;
    }

    public static String getAccessKeySecret() {
        return accessKeySecret;
    }

    public static boolean sendSms(String phone, JSONObject templateParamJson, DySmsEnum dySmsEnum) throws ClientException {
        System.setProperty("sun.net.client.defaultConnectTimeout", "10000");
        System.setProperty("sun.net.client.defaultReadTimeout", "10000");
        StaticConfig staticConfig = SpringContextUtils.getBean(StaticConfig.class);
        DySmsHelper.setAccessKeyId(staticConfig.getAccessKeyId());
        DySmsHelper.setAccessKeySecret(staticConfig.getAccessKeySecret());
        DefaultProfile profile = DefaultProfile.getProfile((String)"cn-hangzhou", (String)accessKeyId, (String)accessKeySecret);
        DefaultProfile.addEndpoint((String)"cn-hangzhou", (String)"cn-hangzhou", (String)product, (String)domain);
        DefaultAcsClient acsClient = new DefaultAcsClient((IClientProfile)profile);
        DySmsHelper.validateParam(templateParamJson, dySmsEnum);
        SendSmsRequest request = new SendSmsRequest();
        request.setPhoneNumbers(phone);
        request.setSignName(dySmsEnum.getSignName());
        request.setTemplateCode(dySmsEnum.getTemplateCode());
        request.setTemplateParam(templateParamJson.toJSONString());
        boolean result = false;
        SendSmsResponse sendSmsResponse = (SendSmsResponse)acsClient.getAcsResponse((AcsRequest)request);
        logger.info("\u77ed\u4fe1\u63a5\u53e3\u8fd4\u56de\u7684\u6570\u636e----------------");
        logger.info("{Code:" + sendSmsResponse.getCode() + ",Message:" + sendSmsResponse.getMessage() + ",RequestId:" + sendSmsResponse.getRequestId() + ",BizId:" + sendSmsResponse.getBizId() + "}");
        if ("OK".equals(sendSmsResponse.getCode())) {
            result = true;
        }
        return result;
    }

    private static void validateParam(JSONObject templateParamJson, DySmsEnum dySmsEnum) {
        String[] keyArr;
        String keys = dySmsEnum.getKeys();
        for (String item : keyArr = keys.split(",")) {
            if (templateParamJson.containsKey((Object)item)) continue;
            throw new RuntimeException("\u6a21\u677f\u7f3a\u5c11\u53c2\u6570\uff1a" + item);
        }
    }
}

