/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.config.mybatis;

import com.baomidou.mybatisplus.core.parser.ISqlParserFilter;
import com.baomidou.mybatisplus.extension.plugins.PaginationInterceptor;
import com.baomidou.mybatisplus.extension.plugins.tenant.TenantHandler;
import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.schema.Column;
import org.apache.ibatis.reflection.MetaObject;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.config.mybatis.JeecgTenantParser;
import org.jeecg.config.mybatis.TenantContext;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@MapperScan(value={"org.jeecg.modules.**.mapper*"})
public class MybatisPlusConfig {
    public static final String tenant_field = "tenant_id";
    private static final List<String> tenantTable = new ArrayList<String>();
    private static final List<String> DDL_KEYWORD = new ArrayList<String>();

    @Bean
    public PaginationInterceptor paginationInterceptor() {
        PaginationInterceptor paginationInterceptor = new PaginationInterceptor().setLimit(-1L);
        this.tenantConfig(paginationInterceptor);
        return paginationInterceptor;
    }

    private void tenantConfig(PaginationInterceptor paginationInterceptor) {
        ArrayList<JeecgTenantParser> sqlParserList = new ArrayList<JeecgTenantParser>();
        JeecgTenantParser tenantSqlParser = new JeecgTenantParser();
        tenantSqlParser.setTenantHandler(new TenantHandler(){

            public Expression getTenantId(boolean select) {
                String tenant_id = oConvertUtils.getString(TenantContext.getTenant(), "0");
                return new LongValue(tenant_id);
            }

            public String getTenantIdColumn() {
                return MybatisPlusConfig.tenant_field;
            }

            public boolean doTableFilter(String tableName) {
                return !tenantTable.contains(tableName);
            }

            private Expression in(String ids) {
                InExpression inExpression = new InExpression();
                inExpression.setLeftExpression((Expression)new Column(this.getTenantIdColumn()));
                ExpressionList itemsList = new ExpressionList();
                ArrayList<LongValue> inValues = new ArrayList<LongValue>(2);
                for (String id : ids.split(",")) {
                    inValues.add(new LongValue(id));
                }
                itemsList.setExpressions(inValues);
                inExpression.setRightItemsList((ItemsList)itemsList);
                return inExpression;
            }
        });
        sqlParserList.add(tenantSqlParser);
        paginationInterceptor.setSqlParserList(sqlParserList);
        paginationInterceptor.setSqlParserFilter(new ISqlParserFilter(){

            public boolean doFilter(MetaObject metaObject) {
                String sql = (String)metaObject.getValue("delegate.boundSql.sql");
                for (String tableName : tenantTable) {
                    String sql_lowercase = sql.toLowerCase();
                    if (sql_lowercase.indexOf(tableName.toLowerCase()) < 0) continue;
                    for (String key : DDL_KEYWORD) {
                        if (sql_lowercase.indexOf(key) < 0) continue;
                        return true;
                    }
                    return false;
                }
                return true;
            }
        });
    }

    static {
        tenantTable.add("jee_bug_danbiao");
        DDL_KEYWORD.add("alter");
    }
}

