/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.util;

import com.alibaba.fastjson.JSONObject;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.common.util.oConvertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class RestUtil {
    private static final Logger log = LoggerFactory.getLogger(RestUtil.class);
    private static String domain = null;
    public static String path = null;
    private static final RestTemplate RT;

    public static String getDomain() {
        if (domain == null) {
            domain = SpringContextUtils.getDomain();
        }
        return domain;
    }

    public static String getPath() {
        if (path == null) {
            path = SpringContextUtils.getApplicationContext().getEnvironment().getProperty("server.servlet.context-path");
        }
        return oConvertUtils.getString(path);
    }

    public static String getBaseUrl() {
        String basepath = RestUtil.getDomain() + RestUtil.getPath();
        log.info(" RestUtil.getBaseUrl: " + basepath);
        return basepath;
    }

    public static RestTemplate getRestTemplate() {
        return RT;
    }

    public static JSONObject get(String url) {
        return (JSONObject)RestUtil.getNative(url, null, null).getBody();
    }

    public static JSONObject get(String url, JSONObject variables) {
        return (JSONObject)RestUtil.getNative(url, variables, null).getBody();
    }

    public static JSONObject get(String url, JSONObject variables, JSONObject params) {
        return (JSONObject)RestUtil.getNative(url, variables, params).getBody();
    }

    public static ResponseEntity<JSONObject> getNative(String url, JSONObject variables, JSONObject params) {
        return RestUtil.request(url, HttpMethod.GET, variables, params);
    }

    public static JSONObject post(String url) {
        return (JSONObject)RestUtil.postNative(url, null, null).getBody();
    }

    public static JSONObject post(String url, JSONObject params) {
        return (JSONObject)RestUtil.postNative(url, null, params).getBody();
    }

    public static JSONObject post(String url, JSONObject variables, JSONObject params) {
        return (JSONObject)RestUtil.postNative(url, variables, params).getBody();
    }

    public static ResponseEntity<JSONObject> postNative(String url, JSONObject variables, JSONObject params) {
        return RestUtil.request(url, HttpMethod.POST, variables, params);
    }

    public static JSONObject put(String url) {
        return (JSONObject)RestUtil.putNative(url, null, null).getBody();
    }

    public static JSONObject put(String url, JSONObject params) {
        return (JSONObject)RestUtil.putNative(url, null, params).getBody();
    }

    public static JSONObject put(String url, JSONObject variables, JSONObject params) {
        return (JSONObject)RestUtil.putNative(url, variables, params).getBody();
    }

    public static ResponseEntity<JSONObject> putNative(String url, JSONObject variables, JSONObject params) {
        return RestUtil.request(url, HttpMethod.PUT, variables, params);
    }

    public static JSONObject delete(String url) {
        return (JSONObject)RestUtil.deleteNative(url, null, null).getBody();
    }

    public static JSONObject delete(String url, JSONObject variables, JSONObject params) {
        return (JSONObject)RestUtil.deleteNative(url, variables, params).getBody();
    }

    public static ResponseEntity<JSONObject> deleteNative(String url, JSONObject variables, JSONObject params) {
        return RestUtil.request(url, HttpMethod.DELETE, null, variables, params, JSONObject.class);
    }

    public static ResponseEntity<JSONObject> request(String url, HttpMethod method, JSONObject variables, JSONObject params) {
        return RestUtil.request(url, method, RestUtil.getHeaderApplicationJson(), variables, params, JSONObject.class);
    }

    public static <T> ResponseEntity<T> request(String url, HttpMethod method, HttpHeaders headers, JSONObject variables, Object params, Class<T> responseType) {
        log.info(" RestUtil  --- request ---  url = " + url);
        if (StringUtils.isEmpty((CharSequence)url)) {
            throw new RuntimeException("url \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (method == null) {
            throw new RuntimeException("method \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (headers == null) {
            headers = new HttpHeaders();
        }
        String body = "";
        if (params != null) {
            body = params instanceof JSONObject ? ((JSONObject)params).toJSONString() : params.toString();
        }
        if (variables != null) {
            url = url + "?" + RestUtil.asUrlVariables(variables);
        }
        HttpEntity request = new HttpEntity((Object)body, (MultiValueMap)headers);
        return RT.exchange(url, method, request, responseType, new Object[0]);
    }

    public static HttpHeaders getHeaderApplicationJson() {
        return RestUtil.getHeader("application/json;charset=UTF-8");
    }

    public static HttpHeaders getHeader(String mediaType) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)mediaType));
        headers.add("Accept", mediaType);
        return headers;
    }

    public static String asUrlVariables(JSONObject variables) {
        Map source = variables.getInnerMap();
        Iterator it = source.keySet().iterator();
        StringBuilder urlVariables = new StringBuilder();
        while (it.hasNext()) {
            String key = (String)it.next();
            String value = "";
            Object object = source.get(key);
            if (object != null && !StringUtils.isEmpty((CharSequence)object.toString())) {
                value = object.toString();
            }
            urlVariables.append("&").append(key).append("=").append(value);
        }
        return urlVariables.substring(1);
    }

    static {
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setConnectTimeout(3000);
        requestFactory.setReadTimeout(3000);
        RT = new RestTemplate((ClientHttpRequestFactory)requestFactory);
        RT.getMessageConverters().set(1, new StringHttpMessageConverter(StandardCharsets.UTF_8));
    }
}

