/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.aspect;

import java.lang.reflect.Method;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.jeecg.common.api.CommonAPI;
import org.jeecg.common.aspect.annotation.PermissionData;
import org.jeecg.common.system.util.JeecgDataAutorUtils;
import org.jeecg.common.system.util.JwtUtil;
import org.jeecg.common.system.vo.SysPermissionDataRuleModel;
import org.jeecg.common.system.vo.SysUserCacheInfo;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.common.util.oConvertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class PermissionDataAspect {
    private static final Logger log = LoggerFactory.getLogger(PermissionDataAspect.class);
    @Autowired
    private CommonAPI commonAPI;

    @Pointcut(value="@annotation(org.jeecg.common.aspect.annotation.PermissionData)")
    public void pointCut() {
    }

    @Around(value="pointCut()")
    public Object arround(ProceedingJoinPoint point) throws Throwable {
        HttpServletRequest request = SpringContextUtils.getHttpServletRequest();
        MethodSignature signature = (MethodSignature)point.getSignature();
        Method method = signature.getMethod();
        PermissionData pd = method.getAnnotation(PermissionData.class);
        String component = pd.pageComponent();
        String requestMethod = request.getMethod();
        String requestPath = request.getRequestURI().substring(request.getContextPath().length());
        requestPath = this.filterUrl(requestPath);
        log.debug("\u62e6\u622a\u8bf7\u6c42 >> " + requestPath + ";\u8bf7\u6c42\u7c7b\u578b >> " + requestMethod);
        String username = JwtUtil.getUserNameByToken(request);
        List<SysPermissionDataRuleModel> dataRules = this.commonAPI.queryPermissionDataRule(component, requestPath, username);
        if (dataRules != null && dataRules.size() > 0) {
            JeecgDataAutorUtils.installDataSearchConditon(request, dataRules);
            SysUserCacheInfo userinfo = this.commonAPI.getCacheUser(username);
            JeecgDataAutorUtils.installUserInfo(request, userinfo);
        }
        return point.proceed();
    }

    private String filterUrl(String requestPath) {
        String url = "";
        if (oConvertUtils.isNotEmpty(requestPath)) {
            url = requestPath.replace("\\", "/");
            url = requestPath.replace("//", "/");
            if (url.indexOf("//") >= 0) {
                url = this.filterUrl(url);
            }
        }
        return url;
    }

    private String getJgAuthRequsetPath(HttpServletRequest request) {
        String queryString = request.getQueryString();
        String requestPath = request.getRequestURI();
        if (oConvertUtils.isNotEmpty(queryString)) {
            requestPath = requestPath + "?" + queryString;
        }
        if (requestPath.indexOf("&") > -1) {
            requestPath = requestPath.substring(0, requestPath.indexOf("&"));
        }
        if (requestPath.indexOf("=") != -1) {
            requestPath = requestPath.indexOf(".do") != -1 ? requestPath.substring(0, requestPath.indexOf(".do") + 3) : requestPath.substring(0, requestPath.indexOf("?"));
        }
        requestPath = requestPath.substring(request.getContextPath().length() + 1);
        return this.filterUrl(requestPath);
    }

    private boolean moHuContain(List<String> list, String key) {
        for (String str : list) {
            if (!key.contains(str)) continue;
            return true;
        }
        return false;
    }
}

