/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.util;

import java.net.InetAddress;

public class UUIDGenerator {
    private static final int IP;
    private static short counter;
    private static final int JVM;

    public static String generate() {
        return new StringBuilder(32).append(UUIDGenerator.format(UUIDGenerator.getIP())).append(UUIDGenerator.format(UUIDGenerator.getJVM())).append(UUIDGenerator.format(UUIDGenerator.getHiTime())).append(UUIDGenerator.format(UUIDGenerator.getLoTime())).append(UUIDGenerator.format(UUIDGenerator.getCount())).toString();
    }

    private static final String format(int intval) {
        String formatted = Integer.toHexString(intval);
        StringBuilder buf = new StringBuilder("00000000");
        buf.replace(8 - formatted.length(), 8, formatted);
        return buf.toString();
    }

    private static final String format(short shortval) {
        String formatted = Integer.toHexString(shortval);
        StringBuilder buf = new StringBuilder("0000");
        buf.replace(4 - formatted.length(), 4, formatted);
        return buf.toString();
    }

    private static final int getJVM() {
        return JVM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final short getCount() {
        Class<UUIDGenerator> clazz = UUIDGenerator.class;
        synchronized (UUIDGenerator.class) {
            if (counter < 0) {
                counter = 0;
            }
            short s = counter;
            counter = (short)(s + 1);
            // ** MonitorExit[var0] (shouldn't be in output)
            return s;
        }
    }

    private static final int getIP() {
        return IP;
    }

    private static final short getHiTime() {
        return (short)(System.currentTimeMillis() >>> 32);
    }

    private static final int getLoTime() {
        return (int)System.currentTimeMillis();
    }

    private static final int toInt(byte[] bytes) {
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            result = (result << 8) - -128 + bytes[i];
        }
        return result;
    }

    static {
        int ipadd;
        try {
            ipadd = UUIDGenerator.toInt(InetAddress.getLocalHost().getAddress());
        }
        catch (Exception e) {
            ipadd = 0;
        }
        IP = ipadd;
        counter = 0;
        JVM = (int)(System.currentTimeMillis() >>> 8);
    }
}

