/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Properties;
import oracle.net.ano.Ano;
import oracle.net.nl.NLException;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;
import oracle.net.ns.AcceptPacket;
import oracle.net.ns.ClientProfile;
import oracle.net.ns.Communication;
import oracle.net.ns.ConnectPacket;
import oracle.net.ns.MarkerPacket;
import oracle.net.ns.NetException;
import oracle.net.ns.NetInputStream;
import oracle.net.ns.NetOutputStream;
import oracle.net.ns.Packet;
import oracle.net.ns.RedirectPacket;
import oracle.net.ns.RefusePacket;
import oracle.net.ns.SQLnetDef;
import oracle.net.ns.SessionAtts;
import oracle.net.nt.ConnOption;
import oracle.net.nt.NTAdapter;
import oracle.net.resolver.AddrResolution;

public class NSProtocol
implements Communication,
SQLnetDef {
    private static final boolean ACTIVATE_ANO = true;
    private AddrResolution addrRes;
    private SessionAtts sAtts = new SessionAtts(Short.MAX_VALUE, Short.MAX_VALUE);
    private MarkerPacket mkPkt;
    private Packet packet;

    public NSProtocol() {
        this.sAtts.connected = false;
    }

    public void connect(String string, Properties properties) throws IOException, NetException {
        RefusePacket refusePacket;
        Object object;
        RedirectPacket redirectPacket;
        AcceptPacket acceptPacket;
        ConnectPacket connectPacket;
        Object object2;
        if (this.sAtts.connected) {
            throw new NetException(201);
        }
        if (string == null) {
            throw new NetException(208);
        }
        NVFactory nVFactory = new NVFactory();
        NVNavigator nVNavigator = new NVNavigator();
        NVPair nVPair = null;
        String string2 = null;
        this.addrRes = new AddrResolution(string, properties);
        if (this.addrRes.connection_revised) {
            string = this.addrRes.getTNSAddress();
            properties = this.addrRes.getUp();
        }
        this.sAtts.profile = new ClientProfile(properties);
        this.establishConnection(string);
        Object var11_7 = null;
        try {
            var11_7 = Class.forName("oracle.net.ano.Ano").newInstance();
            this.sAtts.anoEnabled = true;
        }
        catch (Exception exception) {
            this.sAtts.anoEnabled = false;
        }
        if (var11_7 != null) {
            ((Ano)var11_7).init(this.sAtts);
            this.sAtts.ano = var11_7;
            this.sAtts.anoEnabled = true;
        }
        block15: while (true) {
            object2 = null;
            connectPacket = new ConnectPacket(this.sAtts);
            this.packet = new Packet(this.sAtts, this.sAtts.getSDU());
            try {
                connectPacket.send();
                this.packet.receive();
            }
            catch (InterruptedIOException interruptedIOException) {
                throw interruptedIOException;
            }
            catch (IOException iOException) {
                this.packet.type = 4;
                object2 = iOException;
            }
            switch (this.packet.type) {
                case 2: {
                    acceptPacket = new AcceptPacket(this.packet);
                    break block15;
                }
                case 5: {
                    redirectPacket = new RedirectPacket(this.packet);
                    object = this.sAtts.cOption;
                    this.addrRes.connection_redirected = true;
                    this.sAtts.cOption.nt.disconnect();
                    this.sAtts = this.establishConnection(redirectPacket.getData());
                    this.sAtts.cOption.restoreFromOrigCoption((ConnOption)object);
                    continue block15;
                }
                case 4: {
                    refusePacket = new RefusePacket(this.packet);
                    this.sAtts.cOption.nt.disconnect();
                    this.sAtts.cOption = null;
                    this.establishConnection(null);
                    if (this.sAtts.cOption != null) continue block15;
                    if (object2 != null) {
                        throw object2;
                    }
                    try {
                        NVPair nVPair2;
                        nVPair = nVNavigator.findNVPairRecurse(nVFactory.createNVPair(refusePacket.getData()), "ERROR");
                        if (nVPair != null && (nVPair2 = nVNavigator.findNVPairRecurse(nVPair, "CODE")) != null) {
                            string2 = nVPair2.valueToString();
                        }
                    }
                    catch (NLException nLException) {
                        System.err.println(nLException.getMessage());
                    }
                    throw new NetException(string2 == null ? 206 : Integer.parseInt(string2), string + "\n");
                }
                case 11: {
                    continue block15;
                }
                default: {
                    this.sAtts.cOption.nt.disconnect();
                    throw new NetException(205);
                }
            }
            break;
        }
        this.setNetStreams();
        this.sAtts.connected = true;
        if (properties.get("oracle.net.CONNECT_TIMEOUT") != null) {
            object2 = (String)properties.get("oracle.net.READ_TIMEOUT");
            this.sAtts.cOption.nt.setOption(1, object2 == null ? "0" : object2);
        }
        if ((object2 = (String)this.sAtts.nt.getOption(6)) != null && ((String)object2).equalsIgnoreCase("false")) {
            throw new NetException(405);
        }
        if (this.sAtts.ano != null) {
            this.sAtts.ano.negotiation();
            object = (String)this.sAtts.nt.getOption(2);
            if (object != null && ((String)object).equals("TRUE")) {
                try {
                    Method method = this.sAtts.ano.getClass().getMethod("getEncryptionAlg", null);
                    if (method.invoke((Object)this.sAtts.ano, null) != null) {
                        throw new NetException(406);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.packet = null;
        connectPacket = null;
        acceptPacket = null;
        redirectPacket = null;
        refusePacket = null;
    }

    public void disconnect() throws IOException, NetException {
        if (!this.sAtts.connected) {
            throw new NetException(200);
        }
        IOException iOException = null;
        try {
            this.sAtts.nsOutputStream.close();
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        this.sAtts.connected = false;
        this.sAtts.cOption.nt.disconnect();
        if (iOException != null) {
            throw iOException;
        }
    }

    public void sendBreak() throws IOException, NetException {
        this.sendMarker(1);
    }

    public void sendInterrupt() throws IOException, NetException {
        this.sendMarker(3);
    }

    public void sendReset() throws IOException, NetException {
        if (!this.sAtts.connected) {
            throw new NetException(200);
        }
        this.sendMarker(2);
        while (this.sAtts.onBreakReset) {
            this.packet = new Packet(this.sAtts, this.sAtts.getSDU());
            this.packet.receive();
            if (this.packet.type != 12) continue;
            this.mkPkt = new MarkerPacket(this.packet);
            if (this.mkPkt.data != 2) continue;
            this.sAtts.onBreakReset = false;
        }
        this.mkPkt = null;
    }

    public InputStream getInputStream() throws NetException {
        if (!this.sAtts.connected) {
            throw new NetException(200);
        }
        return this.sAtts.nsInputStream;
    }

    public OutputStream getOutputStream() throws NetException {
        if (!this.sAtts.connected) {
            throw new NetException(200);
        }
        return this.sAtts.nsOutputStream;
    }

    private SessionAtts establishConnection(String string) throws NetException, IOException {
        this.sAtts.cOption = this.addrRes.resolveAndExecute(string);
        if (this.sAtts.cOption == null) {
            return null;
        }
        this.sAtts.nt = this.sAtts.cOption.nt;
        this.sAtts.ntInputStream = this.sAtts.cOption.nt.getInputStream();
        this.sAtts.ntOutputStream = this.sAtts.cOption.nt.getOutputStream();
        this.sAtts.setTDU(this.sAtts.cOption.tdu);
        this.sAtts.setSDU(this.sAtts.cOption.sdu);
        this.sAtts.nsOutputStream = new NetOutputStream(this.sAtts, 255);
        this.sAtts.nsInputStream = new NetInputStream(this.sAtts);
        return this.sAtts;
    }

    private void setNetStreams() throws NetException, IOException {
        this.sAtts.nsOutputStream = new NetOutputStream(this.sAtts);
        this.sAtts.nsInputStream = new NetInputStream(this.sAtts);
    }

    private void sendMarker(int n) throws IOException, NetException {
        if (!this.sAtts.connected) {
            throw new NetException(200);
        }
        this.mkPkt = new MarkerPacket(this.sAtts, n);
        this.mkPkt.send();
        this.mkPkt = null;
    }

    public void setO3logSessionKey(byte[] byArray) throws NetException, NetException {
        if (byArray != null) {
            this.sAtts.ano.setO3logSessionKey(byArray);
        }
    }

    public void setOption(int n, Object object) throws NetException, IOException {
        if (n > 0 && n < 10) {
            NTAdapter nTAdapter = this.sAtts.getNTAdapter();
            nTAdapter.setOption(n, object);
        }
    }

    public Object getOption(int n) throws NetException, IOException {
        if (n > 0 && n < 10) {
            NTAdapter nTAdapter = this.sAtts.getNTAdapter();
            return nTAdapter.getOption(n);
        }
        return null;
    }

    public void abort() throws NetException, IOException {
        NTAdapter nTAdapter = this.sAtts.getNTAdapter();
        if (nTAdapter != null) {
            nTAdapter.abort();
        }
    }
}

